# Global direct primary energy consumption - Data package

This data package contains the data that powers the chart ["Global direct primary energy consumption"](https://ourworldindata.org/grapher/global-primary-energy?csvType=full&useColumnShortNames=false) on the Our World in Data website.

## CSV Structure

The high level structure of the CSV file is that each row is an observation for an entity (usually a country or region) and a timepoint (usually a year).

The first two columns in the CSV file are "Entity" and "Code". "Entity" is the name of the entity (e.g. "United States"). "Code" is the OWID internal entity code that we use if the entity is a country or region. For normal countries, this is the same as the [iso alpha-3](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) code of the entity (e.g. "USA") - for non-standard countries like historical countries these are custom codes.

The third column is either "Year" or "Day". If the data is annual, this is "Year" and contains only the year as an integer. If the column is "Day", the column contains a date string in the form "YYYY-MM-DD".

The remaining columns are the data columns, each of which is a time series. If the CSV data is downloaded using the "full data" option, then each column corresponds to one time series below. If the CSV data is downloaded using the "only selected data visible in the chart" option then the data columns are transformed depending on the chart type and thus the association with the time series might not be as straightforward.

## Metadata.json structure

The .metadata.json file contains metadata about the data package. The "charts" key contains information to recreate the chart, like the title, subtitle etc.. The "columns" key contains information about each of the columns in the csv, like the unit, timespan covered, citation for the data etc..

## About the data

Our World in Data is almost never the original producer of the data - almost all of the data we use has been compiled by others. If you want to re-use data, it is your responsibility to ensure that you adhere to the sources' license and to credit them correctly. Please note that a single time series may have more than one source - e.g. when we stich together data from different time periods by different producers or when we calculate per capita metrics using population data from a second source.

### How we process data at Our World In Data
All data and visualizations on Our World in Data rely on data sourced from one or several original data providers. Preparing this original data involves several processing steps. Depending on the data, this can include standardizing country names and world region definitions, converting units, calculating derived indicators such as per capita measures, as well as adding or adapting metadata such as the name or the description given to an indicator.
[Read about our data pipeline](https://docs.owid.io/projects/etl/)

## Detailed information about each time series


## Direct primary energy from biofuels
Measured in terawatt-hours.
Last updated: June 27, 2025  
Next update: June 2026  
Date range: 1800–2024  
Unit: terawatt-hours  


### How to cite this data

#### In-line citation
If you have limited space (e.g. in data visualizations), you can use this abbreviated in-line citation:  
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data

#### Full citation
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data. “Direct primary energy from biofuels” [dataset]. Energy Institute, “Statistical Review of World Energy”; Smil, “Energy Transitions: Global and National Perspectives” [original data].
Source: Energy Institute - Statistical Review of World Energy (2025), Smil (2017) – with major processing by Our World In Data

### What you should know about this data
* Primary energy data can be quantified using two different methodologies: (1) 'Direct' primary energy, which directly combines fossil fuel data with the electricity generated by nuclear power and renewables. (2) 'Substituted' primary energy, which converts non-fossil electricity into their 'input equivalents': The amount of primary energy that would be needed if they had the same inefficiencies as fossil fuels. This 'substitution method' is adopted by the Energy Institute's Statistical Review of World Energy, when all data is compared in exajoules.

### Sources

#### Energy Institute – Statistical Review of World Energy
Retrieved on: 2025-06-27  
Retrieved from: https://www.energyinst.org/statistical-review/  

#### Smil – Energy Transitions: Global and National Perspectives
Retrieved on: 2023-12-12  
Retrieved from: https://vaclavsmil.com/book/energy-transitions-global-and-national-perspectives-second-expanded-and-updated-edition/  

#### Notes on our processing step for this indicator
- All data prior to the year 1965 is sourced from Smil (2017). All data from 1965 onwards, with the exception of traditional biomass is sourced from the Energy Institute Statistical Review of World Energy. Smil's estimates of traditional biomass are only available until 2015. For the years 2016 onwards, we have assumed a similar level of traditional biomass consumption. This is approximately in line with recent trends in traditional biomass from Smil's data.
- We convert all data from the Statistical Review of World Energy from exajoules (EJ) to terawatt-hours (TWh), using a conversion factor of 1,000,000 / 3,600 (~277.778).


## Direct primary energy from other renewables
Measured in terawatt-hours.
Last updated: June 27, 2025  
Next update: June 2026  
Date range: 1800–2024  
Unit: terawatt-hours  


### How to cite this data

#### In-line citation
If you have limited space (e.g. in data visualizations), you can use this abbreviated in-line citation:  
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data

#### Full citation
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data. “Direct primary energy from other renewables” [dataset]. Energy Institute, “Statistical Review of World Energy”; Smil, “Energy Transitions: Global and National Perspectives” [original data].
Source: Energy Institute - Statistical Review of World Energy (2025), Smil (2017) – with major processing by Our World In Data

### What you should know about this data
* Primary energy data can be quantified using two different methodologies: (1) 'Direct' primary energy, which directly combines fossil fuel data with the electricity generated by nuclear power and renewables. (2) 'Substituted' primary energy, which converts non-fossil electricity into their 'input equivalents': The amount of primary energy that would be needed if they had the same inefficiencies as fossil fuels. This 'substitution method' is adopted by the Energy Institute's Statistical Review of World Energy, when all data is compared in exajoules.

### Sources

#### Energy Institute – Statistical Review of World Energy
Retrieved on: 2025-06-27  
Retrieved from: https://www.energyinst.org/statistical-review/  

#### Smil – Energy Transitions: Global and National Perspectives
Retrieved on: 2023-12-12  
Retrieved from: https://vaclavsmil.com/book/energy-transitions-global-and-national-perspectives-second-expanded-and-updated-edition/  

#### Notes on our processing step for this indicator
- All data prior to the year 1965 is sourced from Smil (2017). All data from 1965 onwards, with the exception of traditional biomass is sourced from the Energy Institute Statistical Review of World Energy. Smil's estimates of traditional biomass are only available until 2015. For the years 2016 onwards, we have assumed a similar level of traditional biomass consumption. This is approximately in line with recent trends in traditional biomass from Smil's data.
- We convert all data from the Statistical Review of World Energy from exajoules (EJ) to terawatt-hours (TWh), using a conversion factor of 1,000,000 / 3,600 (~277.778).


## Direct primary energy from solar power
Measured in terawatt-hours.
Last updated: June 27, 2025  
Next update: June 2026  
Date range: 1800–2024  
Unit: terawatt-hours  


### How to cite this data

#### In-line citation
If you have limited space (e.g. in data visualizations), you can use this abbreviated in-line citation:  
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data

#### Full citation
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data. “Direct primary energy from solar power” [dataset]. Energy Institute, “Statistical Review of World Energy”; Smil, “Energy Transitions: Global and National Perspectives” [original data].
Source: Energy Institute - Statistical Review of World Energy (2025), Smil (2017) – with major processing by Our World In Data

### What you should know about this data
* Primary energy data can be quantified using two different methodologies: (1) 'Direct' primary energy, which directly combines fossil fuel data with the electricity generated by nuclear power and renewables. (2) 'Substituted' primary energy, which converts non-fossil electricity into their 'input equivalents': The amount of primary energy that would be needed if they had the same inefficiencies as fossil fuels. This 'substitution method' is adopted by the Energy Institute's Statistical Review of World Energy, when all data is compared in exajoules.

### Sources

#### Energy Institute – Statistical Review of World Energy
Retrieved on: 2025-06-27  
Retrieved from: https://www.energyinst.org/statistical-review/  

#### Smil – Energy Transitions: Global and National Perspectives
Retrieved on: 2023-12-12  
Retrieved from: https://vaclavsmil.com/book/energy-transitions-global-and-national-perspectives-second-expanded-and-updated-edition/  

#### Notes on our processing step for this indicator
- All data prior to the year 1965 is sourced from Smil (2017). All data from 1965 onwards, with the exception of traditional biomass is sourced from the Energy Institute Statistical Review of World Energy. Smil's estimates of traditional biomass are only available until 2015. For the years 2016 onwards, we have assumed a similar level of traditional biomass consumption. This is approximately in line with recent trends in traditional biomass from Smil's data.
- We convert all data from the Statistical Review of World Energy from exajoules (EJ) to terawatt-hours (TWh), using a conversion factor of 1,000,000 / 3,600 (~277.778).


## Direct primary energy from wind power
Measured in terawatt-hours.
Last updated: June 27, 2025  
Next update: June 2026  
Date range: 1800–2024  
Unit: terawatt-hours  


### How to cite this data

#### In-line citation
If you have limited space (e.g. in data visualizations), you can use this abbreviated in-line citation:  
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data

#### Full citation
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data. “Direct primary energy from wind power” [dataset]. Energy Institute, “Statistical Review of World Energy”; Smil, “Energy Transitions: Global and National Perspectives” [original data].
Source: Energy Institute - Statistical Review of World Energy (2025), Smil (2017) – with major processing by Our World In Data

### What you should know about this data
* Primary energy data can be quantified using two different methodologies: (1) 'Direct' primary energy, which directly combines fossil fuel data with the electricity generated by nuclear power and renewables. (2) 'Substituted' primary energy, which converts non-fossil electricity into their 'input equivalents': The amount of primary energy that would be needed if they had the same inefficiencies as fossil fuels. This 'substitution method' is adopted by the Energy Institute's Statistical Review of World Energy, when all data is compared in exajoules.

### Sources

#### Energy Institute – Statistical Review of World Energy
Retrieved on: 2025-06-27  
Retrieved from: https://www.energyinst.org/statistical-review/  

#### Smil – Energy Transitions: Global and National Perspectives
Retrieved on: 2023-12-12  
Retrieved from: https://vaclavsmil.com/book/energy-transitions-global-and-national-perspectives-second-expanded-and-updated-edition/  

#### Notes on our processing step for this indicator
- All data prior to the year 1965 is sourced from Smil (2017). All data from 1965 onwards, with the exception of traditional biomass is sourced from the Energy Institute Statistical Review of World Energy. Smil's estimates of traditional biomass are only available until 2015. For the years 2016 onwards, we have assumed a similar level of traditional biomass consumption. This is approximately in line with recent trends in traditional biomass from Smil's data.
- We convert all data from the Statistical Review of World Energy from exajoules (EJ) to terawatt-hours (TWh), using a conversion factor of 1,000,000 / 3,600 (~277.778).


## Direct primary energy from hydropower
Measured in terawatt-hours.
Last updated: June 27, 2025  
Next update: June 2026  
Date range: 1800–2024  
Unit: terawatt-hours  


### How to cite this data

#### In-line citation
If you have limited space (e.g. in data visualizations), you can use this abbreviated in-line citation:  
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data

#### Full citation
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data. “Direct primary energy from hydropower” [dataset]. Energy Institute, “Statistical Review of World Energy”; Smil, “Energy Transitions: Global and National Perspectives” [original data].
Source: Energy Institute - Statistical Review of World Energy (2025), Smil (2017) – with major processing by Our World In Data

### What you should know about this data
* Primary energy data can be quantified using two different methodologies: (1) 'Direct' primary energy, which directly combines fossil fuel data with the electricity generated by nuclear power and renewables. (2) 'Substituted' primary energy, which converts non-fossil electricity into their 'input equivalents': The amount of primary energy that would be needed if they had the same inefficiencies as fossil fuels. This 'substitution method' is adopted by the Energy Institute's Statistical Review of World Energy, when all data is compared in exajoules.

### Sources

#### Energy Institute – Statistical Review of World Energy
Retrieved on: 2025-06-27  
Retrieved from: https://www.energyinst.org/statistical-review/  

#### Smil – Energy Transitions: Global and National Perspectives
Retrieved on: 2023-12-12  
Retrieved from: https://vaclavsmil.com/book/energy-transitions-global-and-national-perspectives-second-expanded-and-updated-edition/  

#### Notes on our processing step for this indicator
- All data prior to the year 1965 is sourced from Smil (2017). All data from 1965 onwards, with the exception of traditional biomass is sourced from the Energy Institute Statistical Review of World Energy. Smil's estimates of traditional biomass are only available until 2015. For the years 2016 onwards, we have assumed a similar level of traditional biomass consumption. This is approximately in line with recent trends in traditional biomass from Smil's data.
- We convert all data from the Statistical Review of World Energy from exajoules (EJ) to terawatt-hours (TWh), using a conversion factor of 1,000,000 / 3,600 (~277.778).


## Direct primary energy from nuclear power
Measured in terawatt-hours.
Last updated: June 27, 2025  
Next update: June 2026  
Date range: 1800–2024  
Unit: terawatt-hours  


### How to cite this data

#### In-line citation
If you have limited space (e.g. in data visualizations), you can use this abbreviated in-line citation:  
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data

#### Full citation
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data. “Direct primary energy from nuclear power” [dataset]. Energy Institute, “Statistical Review of World Energy”; Smil, “Energy Transitions: Global and National Perspectives” [original data].
Source: Energy Institute - Statistical Review of World Energy (2025), Smil (2017) – with major processing by Our World In Data

### What you should know about this data
* Primary energy data can be quantified using two different methodologies: (1) 'Direct' primary energy, which directly combines fossil fuel data with the electricity generated by nuclear power and renewables. (2) 'Substituted' primary energy, which converts non-fossil electricity into their 'input equivalents': The amount of primary energy that would be needed if they had the same inefficiencies as fossil fuels. This 'substitution method' is adopted by the Energy Institute's Statistical Review of World Energy, when all data is compared in exajoules.

### Sources

#### Energy Institute – Statistical Review of World Energy
Retrieved on: 2025-06-27  
Retrieved from: https://www.energyinst.org/statistical-review/  

#### Smil – Energy Transitions: Global and National Perspectives
Retrieved on: 2023-12-12  
Retrieved from: https://vaclavsmil.com/book/energy-transitions-global-and-national-perspectives-second-expanded-and-updated-edition/  

#### Notes on our processing step for this indicator
- All data prior to the year 1965 is sourced from Smil (2017). All data from 1965 onwards, with the exception of traditional biomass is sourced from the Energy Institute Statistical Review of World Energy. Smil's estimates of traditional biomass are only available until 2015. For the years 2016 onwards, we have assumed a similar level of traditional biomass consumption. This is approximately in line with recent trends in traditional biomass from Smil's data.
- We convert all data from the Statistical Review of World Energy from exajoules (EJ) to terawatt-hours (TWh), using a conversion factor of 1,000,000 / 3,600 (~277.778).


## Direct primary energy from natural gas
Measured in terawatt-hours.
Last updated: June 27, 2025  
Next update: June 2026  
Date range: 1800–2024  
Unit: terawatt-hours  


### How to cite this data

#### In-line citation
If you have limited space (e.g. in data visualizations), you can use this abbreviated in-line citation:  
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data

#### Full citation
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data. “Direct primary energy from natural gas” [dataset]. Energy Institute, “Statistical Review of World Energy”; Smil, “Energy Transitions: Global and National Perspectives” [original data].
Source: Energy Institute - Statistical Review of World Energy (2025), Smil (2017) – with major processing by Our World In Data

### What you should know about this data
* Primary energy data can be quantified using two different methodologies: (1) 'Direct' primary energy, which directly combines fossil fuel data with the electricity generated by nuclear power and renewables. (2) 'Substituted' primary energy, which converts non-fossil electricity into their 'input equivalents': The amount of primary energy that would be needed if they had the same inefficiencies as fossil fuels. This 'substitution method' is adopted by the Energy Institute's Statistical Review of World Energy, when all data is compared in exajoules.

### Sources

#### Energy Institute – Statistical Review of World Energy
Retrieved on: 2025-06-27  
Retrieved from: https://www.energyinst.org/statistical-review/  

#### Smil – Energy Transitions: Global and National Perspectives
Retrieved on: 2023-12-12  
Retrieved from: https://vaclavsmil.com/book/energy-transitions-global-and-national-perspectives-second-expanded-and-updated-edition/  

#### Notes on our processing step for this indicator
- All data prior to the year 1965 is sourced from Smil (2017). All data from 1965 onwards, with the exception of traditional biomass is sourced from the Energy Institute Statistical Review of World Energy. Smil's estimates of traditional biomass are only available until 2015. For the years 2016 onwards, we have assumed a similar level of traditional biomass consumption. This is approximately in line with recent trends in traditional biomass from Smil's data.
- We convert all data from the Statistical Review of World Energy from exajoules (EJ) to terawatt-hours (TWh), using a conversion factor of 1,000,000 / 3,600 (~277.778).


## Direct primary energy from oil
Measured in terawatt-hours.
Last updated: June 27, 2025  
Next update: June 2026  
Date range: 1800–2024  
Unit: terawatt-hours  


### How to cite this data

#### In-line citation
If you have limited space (e.g. in data visualizations), you can use this abbreviated in-line citation:  
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data

#### Full citation
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data. “Direct primary energy from oil” [dataset]. Energy Institute, “Statistical Review of World Energy”; Smil, “Energy Transitions: Global and National Perspectives” [original data].
Source: Energy Institute - Statistical Review of World Energy (2025), Smil (2017) – with major processing by Our World In Data

### What you should know about this data
* Primary energy data can be quantified using two different methodologies: (1) 'Direct' primary energy, which directly combines fossil fuel data with the electricity generated by nuclear power and renewables. (2) 'Substituted' primary energy, which converts non-fossil electricity into their 'input equivalents': The amount of primary energy that would be needed if they had the same inefficiencies as fossil fuels. This 'substitution method' is adopted by the Energy Institute's Statistical Review of World Energy, when all data is compared in exajoules.

### Sources

#### Energy Institute – Statistical Review of World Energy
Retrieved on: 2025-06-27  
Retrieved from: https://www.energyinst.org/statistical-review/  

#### Smil – Energy Transitions: Global and National Perspectives
Retrieved on: 2023-12-12  
Retrieved from: https://vaclavsmil.com/book/energy-transitions-global-and-national-perspectives-second-expanded-and-updated-edition/  

#### Notes on our processing step for this indicator
- All data prior to the year 1965 is sourced from Smil (2017). All data from 1965 onwards, with the exception of traditional biomass is sourced from the Energy Institute Statistical Review of World Energy. Smil's estimates of traditional biomass are only available until 2015. For the years 2016 onwards, we have assumed a similar level of traditional biomass consumption. This is approximately in line with recent trends in traditional biomass from Smil's data.
- We convert all data from the Statistical Review of World Energy from exajoules (EJ) to terawatt-hours (TWh), using a conversion factor of 1,000,000 / 3,600 (~277.778).


## Direct primary energy from coal
Measured in terawatt-hours.
Last updated: June 27, 2025  
Next update: June 2026  
Date range: 1800–2024  
Unit: terawatt-hours  


### How to cite this data

#### In-line citation
If you have limited space (e.g. in data visualizations), you can use this abbreviated in-line citation:  
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data

#### Full citation
Energy Institute - Statistical Review of World Energy (2025); Smil (2017) – with major processing by Our World in Data. “Direct primary energy from coal” [dataset]. Energy Institute, “Statistical Review of World Energy”; Smil, “Energy Transitions: Global and National Perspectives” [original data].
Source: Energy Institute - Statistical Review of World Energy (2025), Smil (2017) – with major processing by Our World In Data

### What you should know about this data
* Primary energy data can be quantified using two different methodologies: (1) 'Direct' primary energy, which directly combines fossil fuel data with the electricity generated by nuclear power and renewables. (2) 'Substituted' primary energy, which converts non-fossil electricity into their 'input equivalents': The amount of primary energy that would be needed if they had the same inefficiencies as fossil fuels. This 'substitution method' is adopted by the Energy Institute's Statistical Review of World Energy, when all data is compared in exajoules.

### Sources

#### Energy Institute – Statistical Review of World Energy
Retrieved on: 2025-06-27  
Retrieved from: https://www.energyinst.org/statistical-review/  

#### Smil – Energy Transitions: Global and National Perspectives
Retrieved on: 2023-12-12  
Retrieved from: https://vaclavsmil.com/book/energy-transitions-global-and-national-perspectives-second-expanded-and-updated-edition/  

#### Notes on our processing step for this indicator
- All data prior to the year 1965 is sourced from Smil (2017). All data from 1965 onwards, with the exception of traditional biomass is sourced from the Energy Institute Statistical Review of World Energy. Smil's estimates of traditional biomass are only available until 2015. For the years 2016 onwards, we have assumed a similar level of traditional biomass consumption. This is approximately in line with recent trends in traditional biomass from Smil's data.
- We convert all data from the Statistical Review of World Energy from exajoules (EJ) to terawatt-hours (TWh), using a conversion factor of 1,000,000 / 3,600 (~277.778).


## Direct primary energy from traditional biomass
Measured in terawatt-hours.
Last updated: June 27, 2025  
Next update: June 2026  
Date range: 1800–2024  
Unit: terawatt-hours  


### How to cite this data

#### In-line citation
If you have limited space (e.g. in data visualizations), you can use this abbreviated in-line citation:  
Smil (2017) – with major processing by Our World in Data

#### Full citation
Smil (2017) – with major processing by Our World in Data. “Direct primary energy from traditional biomass” [dataset]. Smil, “Energy Transitions: Global and National Perspectives” [original data].
Source: Smil (2017) – with major processing by Our World In Data

### What you should know about this data
* Primary energy data can be quantified using two different methodologies: (1) 'Direct' primary energy, which directly combines fossil fuel data with the electricity generated by nuclear power and renewables. (2) 'Substituted' primary energy, which converts non-fossil electricity into their 'input equivalents': The amount of primary energy that would be needed if they had the same inefficiencies as fossil fuels. This 'substitution method' is adopted by the Energy Institute's Statistical Review of World Energy, when all data is compared in exajoules.

### Source

#### Smil – Energy Transitions: Global and National Perspectives
Retrieved on: 2023-12-12  
Retrieved from: https://vaclavsmil.com/book/energy-transitions-global-and-national-perspectives-second-expanded-and-updated-edition/  

#### Notes on our processing step for this indicator
- All data prior to the year 1965 is sourced from Smil (2017). All data from 1965 onwards, with the exception of traditional biomass is sourced from the Energy Institute Statistical Review of World Energy. Smil's estimates of traditional biomass are only available until 2015. For the years 2016 onwards, we have assumed a similar level of traditional biomass consumption. This is approximately in line with recent trends in traditional biomass from Smil's data.
- We convert all data from the Statistical Review of World Energy from exajoules (EJ) to terawatt-hours (TWh), using a conversion factor of 1,000,000 / 3,600 (~277.778).


    